import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SendBulkEmail$ } from "../schemas/schemas_0";
export { $Command };
export class SendBulkEmailCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    EndpointId: { type: "contextParams", name: "EndpointId" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("SimpleEmailService_v2", "SendBulkEmail", {})
    .n("SESv2Client", "SendBulkEmailCommand")
    .sc(SendBulkEmail$)
    .build() {
}
