import type { ErrorInfo } from 'react';
declare global {
    var __next_log_error__: undefined | ((err: unknown) => void);
}
type RSCErrorHandler = (err: unknown) => string | undefined;
type SSRErrorHandler = (err: unknown, errorInfo?: ErrorInfo) => string | undefined;
export type DigestedError = Error & {
    digest: string;
    environmentName?: string;
};
/**
 * Returns a digest for well-known Next.js errors, otherwise `undefined`. If a
 * digest is returned this also means that the error does not need to be
 * reported.
 */
export declare function getDigestForWellKnownError(error: unknown): string | undefined;
export declare function createReactServerErrorHandler(shouldFormatError: boolean, isNextExport: boolean, reactServerErrors: Map<string, DigestedError>, onReactServerRenderError: (err: DigestedError, silenceLog: boolean) => void, spanToRecordOn?: any): RSCErrorHandler;
export declare function createHTMLErrorHandler(shouldFormatError: boolean, isNextExport: boolean, reactServerErrors: Map<string, DigestedError>, allCapturedErrors: Array<unknown>, onHTMLRenderSSRError: (err: DigestedError, errorInfo?: ErrorInfo) => void, spanToRecordOn?: any): SSRErrorHandler;
export declare function isUserLandError(err: any): boolean;
export {};
