const { execSync, spawn } = require('child_process');
const path = require('path');

// Set production environment
process.env.NODE_ENV = 'production';

// Get the directory of this script
const appDir = __dirname;

// Check if .next folder exists (built app)
const fs = require('fs');
const nextDir = path.join(appDir, '.next');

if (!fs.existsSync(nextDir)) {
  console.log('Building Next.js application...');
  try {
    execSync('npm run build', { 
      cwd: appDir, 
      stdio: 'inherit',
      env: { ...process.env, NODE_ENV: 'production' }
    });
  } catch (error) {
    console.error('Build failed:', error.message);
    process.exit(1);
  }
}

// Start the Next.js production server
console.log('Starting Next.js production server...');
const server = spawn('npm', ['run', 'start'], {
  cwd: appDir,
  stdio: 'inherit',
  env: { ...process.env, NODE_ENV: 'production', PORT: process.env.PORT || 3000 },
  shell: true
});

server.on('error', (error) => {
  console.error('Failed to start server:', error.message);
  process.exit(1);
});

server.on('close', (code) => {
  console.log(`Server process exited with code ${code}`);
  process.exit(code);
});

