import Link from "next/link";

// Icons as components
const StarIcon = () => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
  >
    <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
  </svg>
);

const ArrowIcon = () => (
  <svg
    viewBox="0 0 24 24"
    fill="none"
    stroke="currentColor"
    strokeWidth="2"
    className="w-[18px] h-[18px] transition-transform group-hover:translate-x-1"
  >
    <line x1="5" y1="12" x2="19" y2="12"></line>
    <polyline points="12 5 19 12 12 19"></polyline>
  </svg>
);

const services = [
  {
    id: "small-business",
    title: "Small Business Websites",
    description:
      "Clean, professional, mobile-responsive websites built on Wix, Squarespace, or WordPress. Perfect for local businesses and solo operators.",
    price: "Starting at $800",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
        className="w-7 h-7"
      >
        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
        <line x1="3" y1="9" x2="21" y2="9"></line>
        <line x1="9" y1="21" x2="9" y2="9"></line>
      </svg>
    ),
  },
  {
    id: "custom-dev",
    title: "Custom Web Development",
    description:
      "Full-stack development with Next.js for web apps, dashboards, and custom integrations. Built for advanced functionality and scalability.",
    price: "Quote-based pricing",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
        className="w-7 h-7"
      >
        <polyline points="16 18 22 12 16 6"></polyline>
        <polyline points="8 6 2 12 8 18"></polyline>
      </svg>
    ),
  },
  {
    id: "hosting",
    title: "Hosting & Maintenance",
    description:
      "Managed hosting with security updates, regular backups, and minor content edits. Keep your site running smoothly.",
    price: "Monthly & yearly plans",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        strokeLinecap="round"
        strokeLinejoin="round"
        className="w-7 h-7"
      >
        <rect x="2" y="2" width="20" height="8" rx="2" ry="2"></rect>
        <rect x="2" y="14" width="20" height="8" rx="2" ry="2"></rect>
        <line x1="6" y1="6" x2="6.01" y2="6"></line>
        <line x1="6" y1="18" x2="6.01" y2="18"></line>
      </svg>
    ),
  },
];

const features = [
  {
    title: "Reliable & Secure",
    description:
      "Your site stays online, loads fast, and remains protected from threats.",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        className="w-8 h-8"
      >
        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
      </svg>
    ),
  },
  {
    title: "On-Time Delivery",
    description:
      "Clear timelines and regular updates so you know exactly what to expect.",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        className="w-8 h-8"
      >
        <circle cx="12" cy="12" r="10"></circle>
        <polyline points="12 6 12 12 16 14"></polyline>
      </svg>
    ),
  },
  {
    title: "Clear Communication",
    description:
      "No jargon, no confusion — just straightforward conversations about your project.",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        className="w-8 h-8"
      >
        <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
      </svg>
    ),
  },
  {
    title: "Personal Support",
    description:
      "Work directly with the person building your site, not a support queue.",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        className="w-8 h-8"
      >
        <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
        <circle cx="9" cy="7" r="4"></circle>
        <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
        <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
      </svg>
    ),
  },
  {
    title: "Transparent Pricing",
    description:
      "Know what you're paying for upfront with clear, honest pricing.",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        className="w-8 h-8"
      >
        <line x1="12" y1="1" x2="12" y2="23"></line>
        <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
      </svg>
    ),
  },
  {
    title: "Room to Grow",
    description: "Start simple and expand your site as your business grows.",
    icon: (
      <svg
        viewBox="0 0 24 24"
        fill="none"
        stroke="currentColor"
        strokeWidth="2"
        className="w-8 h-8"
      >
        <polyline points="23 6 13.5 15.5 8.5 10.5 1 18"></polyline>
        <polyline points="17 6 23 6 23 12"></polyline>
      </svg>
    ),
  },
];

const steps = [
  {
    number: 1,
    title: "Discovery Call",
    description:
      "Tell us about your business and goals in a free consultation.",
  },
  {
    number: 2,
    title: "Custom Proposal",
    description: "Receive a clear plan with timeline and pricing.",
  },
  {
    number: 3,
    title: "Design & Build",
    description: "We create your site with regular updates and feedback rounds.",
  },
  {
    number: 4,
    title: "Launch & Support",
    description: "Go live with confidence and ongoing support.",
  },
];

export default function Home() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-[calc(80px+var(--space-3xl))] pb-[var(--space-3xl)] bg-gradient-to-br from-white to-[var(--color-light-gray)] relative overflow-hidden">
        <div className="absolute -top-1/2 -right-[20%] w-[60%] h-[150%] bg-[radial-gradient(circle,rgba(15,118,110,0.05)_0%,transparent_70%)] pointer-events-none"></div>
        <div className="max-w-[var(--container-max)] mx-auto px-[var(--space-lg)]">
          <div className="max-w-[720px] relative z-10">
            <div className="animate-in inline-flex items-center gap-[var(--space-xs)] px-4 py-2 bg-[rgba(15,118,110,0.1)] text-[var(--color-primary)] font-[var(--font-heading)] text-[0.875rem] font-semibold rounded-full mb-[var(--space-lg)]">
              <StarIcon />
              Web Development Made Simple
            </div>
            <h1 className="animate-in animate-delay-1 text-[clamp(2.5rem,5vw,4rem)] font-bold leading-[1.1] mb-[var(--space-md)]">
              Build Your Online Presence
              <br />
              <span className="text-[var(--color-primary)]">
                Without the Headache
              </span>
            </h1>
            <p className="animate-in animate-delay-2 text-[1.25rem] text-[var(--color-text-muted)] mb-[var(--space-xl)] max-w-[560px]">
              We help small businesses and creators launch modern, professional
              websites and web applications — no technical knowledge required.
            </p>
            <div className="animate-in animate-delay-3 flex flex-wrap gap-[var(--space-md)]">
              <Link
                href="/services"
                className="inline-flex items-center justify-center gap-[var(--space-xs)] px-7 py-4 bg-[var(--color-primary)] text-white font-[var(--font-heading)] text-lg font-semibold rounded-[var(--radius-md)] shadow-md hover:bg-[var(--color-primary-dark)] hover:-translate-y-0.5 hover:shadow-lg transition-all"
              >
                View Our Services
              </Link>
              <Link
                href="/contact"
                className="inline-flex items-center justify-center gap-[var(--space-xs)] px-7 py-4 bg-transparent text-[var(--color-primary)] font-[var(--font-heading)] text-lg font-semibold rounded-[var(--radius-md)] border-2 border-[var(--color-primary)] hover:bg-[var(--color-primary)] hover:text-white transition-all"
              >
                Get a Free Quote
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Services Preview */}
      <section className="py-[var(--space-3xl)]">
        <div className="max-w-[var(--container-max)] mx-auto px-[var(--space-lg)]">
          <div className="text-center max-w-[640px] mx-auto mb-[var(--space-2xl)]">
            <span className="inline-block font-[var(--font-heading)] text-[0.875rem] font-semibold text-[var(--color-primary)] uppercase tracking-wider mb-[var(--space-sm)]">
              What We Offer
            </span>
            <h2 className="text-[clamp(2rem,4vw,3rem)] font-semibold mb-[var(--space-md)]">
              Services Tailored to Your Needs
            </h2>
            <p className="text-[1.125rem] text-[var(--color-text-muted)]">
              Whether you need a simple business website or a custom web
              application, we&apos;ve got you covered.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-[var(--space-lg)]">
            {services.map((service) => (
              <div
                key={service.id}
                className="group bg-white border border-[var(--color-border)] rounded-[var(--radius-lg)] p-[var(--space-xl)] transition-all hover:border-[var(--color-primary)] hover:shadow-xl hover:-translate-y-1 relative overflow-hidden before:content-[''] before:absolute before:top-0 before:left-0 before:right-0 before:h-1 before:bg-[var(--color-primary)] before:scale-x-0 before:transition-transform hover:before:scale-x-100"
              >
                <div className="w-14 h-14 flex items-center justify-center bg-[rgba(15,118,110,0.1)] text-[var(--color-primary)] rounded-[var(--radius-md)] mb-[var(--space-md)]">
                  {service.icon}
                </div>
                <h3 className="text-[clamp(1.5rem,3vw,2rem)] font-semibold mb-[var(--space-sm)]">
                  {service.title}
                </h3>
                <p className="text-[var(--color-text-muted)] mb-[var(--space-md)]">
                  {service.description}
                </p>
                <p className="font-[var(--font-heading)] text-[0.9375rem] font-semibold text-[var(--color-secondary)] mb-[var(--space-md)]">
                  {service.price}
                </p>
                <Link
                  href={`/services#${service.id}`}
                  className="group inline-flex items-center gap-[var(--space-xs)] font-[var(--font-heading)] text-[0.9375rem] font-semibold text-[var(--color-primary)]"
                >
                  Learn More
                  <ArrowIcon />
                </Link>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* Why Choose Us */}
      <section className="py-[var(--space-3xl)] bg-[var(--color-light-gray)]">
        <div className="max-w-[var(--container-max)] mx-auto px-[var(--space-lg)]">
          <div className="text-center max-w-[640px] mx-auto mb-[var(--space-2xl)]">
            <span className="inline-block font-[var(--font-heading)] text-[0.875rem] font-semibold text-[var(--color-primary)] uppercase tracking-wider mb-[var(--space-sm)]">
              Why Traunico
            </span>
            <h2 className="text-[clamp(2rem,4vw,3rem)] font-semibold mb-[var(--space-md)]">
              Built for Small Businesses
            </h2>
            <p className="text-[1.125rem] text-[var(--color-text-muted)]">
              We understand the challenges you face and deliver solutions that
              actually work for you.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-[var(--space-lg)]">
            {features.map((feature, index) => (
              <div key={index} className="text-center p-[var(--space-lg)]">
                <div className="w-16 h-16 flex items-center justify-center bg-gradient-to-br from-[rgba(15,118,110,0.1)] to-[rgba(109,40,217,0.1)] text-[var(--color-primary)] rounded-[var(--radius-lg)] mx-auto mb-[var(--space-md)]">
                  {feature.icon}
                </div>
                <h4 className="text-[1.25rem] font-semibold mb-[var(--space-sm)]">
                  {feature.title}
                </h4>
                <p className="text-[1rem] text-[var(--color-text-muted)]">
                  {feature.description}
                </p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* How It Works */}
      <section className="py-[var(--space-3xl)] bg-[var(--color-light-gray)]">
        <div className="max-w-[var(--container-max)] mx-auto px-[var(--space-lg)]">
          <div className="text-center max-w-[640px] mx-auto mb-[var(--space-2xl)]">
            <span className="inline-block font-[var(--font-heading)] text-[0.875rem] font-semibold text-[var(--color-primary)] uppercase tracking-wider mb-[var(--space-sm)]">
              Simple Process
            </span>
            <h2 className="text-[clamp(2rem,4vw,3rem)] font-semibold mb-[var(--space-md)]">
              How It Works
            </h2>
            <p className="text-[1.125rem] text-[var(--color-text-muted)]">
              Getting started is easy. Here&apos;s what to expect.
            </p>
          </div>

          <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-[var(--space-lg)]">
            {steps.map((step) => (
              <div key={step.number} className="text-center relative">
                <div className="w-[72px] h-[72px] flex items-center justify-center bg-white border-2 border-[var(--color-primary)] text-[var(--color-primary)] font-[var(--font-heading)] text-2xl font-bold rounded-full mx-auto mb-[var(--space-md)] relative z-10">
                  {step.number}
                </div>
                <h4 className="text-[1.125rem] font-semibold mb-[var(--space-xs)]">
                  {step.title}
                </h4>
                <p className="text-[1rem] text-[var(--color-text-muted)]">
                  {step.description}
                </p>
              </div>
            ))}
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-[var(--space-3xl)] bg-gradient-to-br from-[var(--color-primary)] to-[var(--color-primary-dark)] text-white text-center">
        <div className="max-w-[var(--container-narrow)] mx-auto px-[var(--space-lg)]">
          <h2 className="text-[clamp(2rem,4vw,3rem)] font-semibold text-white mb-[var(--space-md)]">
            Ready to Get Started?
          </h2>
          <p className="text-[1.25rem] text-white/90 max-w-[560px] mx-auto mb-[var(--space-xl)]">
            Let&apos;s discuss your project and find the perfect solution for
            your business.
          </p>
          <Link
            href="/contact"
            className="inline-flex items-center justify-center gap-[var(--space-xs)] px-7 py-4 bg-white text-[var(--color-primary)] font-[var(--font-heading)] text-lg font-semibold rounded-[var(--radius-md)] shadow-md hover:bg-[var(--color-light-gray)] hover:-translate-y-0.5 hover:shadow-lg transition-all"
          >
            Contact Us Today
          </Link>
        </div>
      </section>
    </>
  );
}
