import Link from "next/link";

export default function Footer() {
  return (
    <footer className="bg-[var(--color-text)] text-white/70 py-[var(--space-2xl)] pb-[var(--space-lg)]">
      <div className="max-w-[var(--container-max)] mx-auto px-[var(--space-lg)]">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-[var(--space-2xl)] mb-[var(--space-2xl)]">
          {/* Brand */}
          <div className="max-w-[280px]">
            <Link
              href="/"
              className="font-[var(--font-heading)] text-2xl font-bold text-white tracking-tight mb-[var(--space-md)] inline-block"
            >
              Trau<span className="text-[var(--color-primary-light)]">nico</span>
            </Link>
            <p className="text-[0.9375rem] leading-relaxed">
              Helping small businesses build modern, reliable websites and web
              applications since 2024.
            </p>
          </div>

          {/* Services */}
          <div>
            <h4 className="font-[var(--font-heading)] text-[0.875rem] font-semibold text-white uppercase tracking-wider mb-[var(--space-md)]">
              Services
            </h4>
            <ul className="space-y-[var(--space-xs)]">
              <li>
                <Link
                  href="/services#small-business"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Small Business Sites
                </Link>
              </li>
              <li>
                <Link
                  href="/services#custom-dev"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Custom Development
                </Link>
              </li>
              <li>
                <Link
                  href="/services#hosting"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Hosting & Maintenance
                </Link>
              </li>
            </ul>
          </div>

          {/* Company */}
          <div>
            <h4 className="font-[var(--font-heading)] text-[0.875rem] font-semibold text-white uppercase tracking-wider mb-[var(--space-md)]">
              Company
            </h4>
            <ul className="space-y-[var(--space-xs)]">
              <li>
                <Link
                  href="/services"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Services
                </Link>
              </li>
              <li>
                <Link
                  href="/services#pricing"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Pricing
                </Link>
              </li>
              <li>
                <Link
                  href="/contact"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Contact
                </Link>
              </li>
            </ul>
          </div>

          {/* Get in Touch */}
          <div>
            <h4 className="font-[var(--font-heading)] text-[0.875rem] font-semibold text-white uppercase tracking-wider mb-[var(--space-md)]">
              Get in Touch
            </h4>
            <ul className="space-y-[var(--space-xs)]">
              <li>
                <Link
                  href="/contact"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  Start a Project
                </Link>
              </li>
              <li>
                <a
                  href="mailto:team@traunico.com"
                  className="text-[0.9375rem] hover:text-white transition-colors"
                >
                  team@traunico.com
                </a>
              </li>
            </ul>
          </div>
        </div>

        <div className="border-t border-white/10 pt-[var(--space-lg)] flex flex-col md:flex-row justify-between items-center gap-[var(--space-md)] text-[0.875rem]">
          <p>&copy; {new Date().getFullYear()} Traunico. All rights reserved.</p>
          <div className="flex gap-[var(--space-md)]">
            <a
              href="#"
              aria-label="LinkedIn"
              className="hover:text-[var(--color-primary-light)] transition-colors"
            >
              <svg viewBox="0 0 24 24" fill="currentColor" className="w-5 h-5">
                <path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z"></path>
                <rect x="2" y="9" width="4" height="12"></rect>
                <circle cx="4" cy="4" r="2"></circle>
              </svg>
            </a>
            <a
              href="#"
              aria-label="Twitter"
              className="hover:text-[var(--color-primary-light)] transition-colors"
            >
              <svg viewBox="0 0 24 24" fill="currentColor" className="w-5 h-5">
                <path d="M23 3a10.9 10.9 0 0 1-3.14 1.53 4.48 4.48 0 0 0-7.86 3v1A10.66 10.66 0 0 1 3 4s-4 9 5 13a11.64 11.64 0 0 1-7 2c9 5 20 0 20-11.5a4.5 4.5 0 0 0-.08-.83A7.72 7.72 0 0 0 23 3z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>
    </footer>
  );
}

