"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";
import { useState, useEffect } from "react";

export default function Header() {
  const pathname = usePathname();
  const [isMenuOpen, setIsMenuOpen] = useState(false);
  const [isScrolled, setIsScrolled] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 80);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const navLinks = [
    { href: "/", label: "Home" },
    { href: "/services", label: "Services" },
    { href: "/services#pricing", label: "Pricing" },
    { href: "/contact", label: "Contact" },
  ];

  return (
    <header
      className={`fixed top-0 left-0 right-0 z-50 bg-white/95 backdrop-blur-sm border-b border-[var(--color-border)] transition-all ${
        isScrolled ? "shadow-md" : ""
      }`}
    >
      <div className="max-w-[var(--container-max)] mx-auto px-[var(--space-lg)] flex items-center justify-between h-20">
        <Link
          href="/"
          className="font-[var(--font-heading)] text-2xl font-bold text-[var(--color-text)] tracking-tight"
        >
          Trau<span className="text-[var(--color-primary)]">nico</span>
        </Link>

        <nav className="flex items-center gap-[var(--space-lg)]">
          <ul
            className={`
              md:flex md:items-center md:gap-[var(--space-md)] md:static md:bg-transparent md:p-0 md:border-0
              ${isMenuOpen ? "flex" : "hidden"}
              flex-col md:flex-row
              absolute md:relative top-full left-0 right-0
              bg-white p-[var(--space-lg)] md:p-0
              border-b md:border-0 border-[var(--color-border)]
              gap-[var(--space-sm)]
            `}
          >
            {navLinks.map((link) => (
              <li key={link.href}>
                <Link
                  href={link.href}
                  className={`
                    font-[var(--font-heading)] text-[0.9375rem] font-medium
                    px-[var(--space-sm)] py-[var(--space-xs)] rounded-[var(--radius-sm)]
                    transition-colors
                    ${
                      pathname === link.href ||
                      (link.href !== "/" && pathname.startsWith(link.href.split("#")[0]))
                        ? "text-[var(--color-primary)]"
                        : "text-[var(--color-text-muted)] hover:text-[var(--color-primary)]"
                    }
                  `}
                  onClick={() => setIsMenuOpen(false)}
                >
                  {link.label}
                </Link>
              </li>
            ))}
          </ul>

          <Link
            href="/contact"
            className="hidden sm:inline-flex items-center justify-center gap-[var(--space-xs)] px-5 py-2.5 bg-[var(--color-primary)] text-white font-[var(--font-heading)] text-sm font-semibold rounded-[var(--radius-md)] shadow-md hover:bg-[var(--color-primary-dark)] hover:-translate-y-0.5 hover:shadow-lg transition-all"
          >
            Start a Project
          </Link>

          <button
            className="flex md:hidden flex-col gap-[5px] p-[var(--space-xs)] bg-transparent border-0 cursor-pointer"
            onClick={() => setIsMenuOpen(!isMenuOpen)}
            aria-label="Toggle navigation"
          >
            <span className="block w-6 h-0.5 bg-[var(--color-text)] transition-all"></span>
            <span className="block w-6 h-0.5 bg-[var(--color-text)] transition-all"></span>
            <span className="block w-6 h-0.5 bg-[var(--color-text)] transition-all"></span>
          </button>
        </nav>
      </div>
    </header>
  );
}

